<?php
/*
=====================================================
 DleMovie (Module for CMS DataLife Engine)
-----------------------------------------------------
 Copyright (c) 2011, 2012 Alexander Ahminenko
=====================================================
     
-----------------------------------------------------
 E-Mail, ICQ: a.ahminenko@gmail.com, 681216
=====================================================
*/
if ( ! defined( 'DATALIFEENGINE' ) ) {
	die( 'Hacking attempt!' );
}
include ENGINE_DIR . '/data/dlemovie.php';
include ENGINE_DIR . '/modules/dlemovie/classes/dlemovie.class.php';

$dlemovie = new DleMovie( $db, $dlemovie_config, $config );
$dlemovie->lang = $dlemovie_lang;

if ( $dlemovie->config['informers'] != 'yes' ) echo $dlemovie->lang['informer_not_allow'];
else {
	$istext = ( $type == 'graph' ) ? false : true;
	$order = ( $order == 'desc' ) ? 'desc' : 'asc';
	$sorting = ( $sorting == 'date' or $sorting == 'rating' or $sorting == 'views' or $sorting = 'comments' ) ? $sorting : 'date';
	$maxday = ( $maxday > 0 ) ? $maxday : 0;
	$provider = ( ! empty( $dlemovie->providers[$provider] ) ) ? $provider : 'all';
	$limit = ( $limit > 0 and $limit <= 100 ) ? $limit : 10;
	$tostr = ( $tostr > 0 and $tostr <= 5 ) ? $tostr : 1;
	$tplfile = empty( $tplfile ) ? 'block-video.tpl' : $tplfile;
	$category = ( $category != 'null' and ! empty( $category ) ) ? explode( ',', $category ) : true;
	if ( is_array( $category ) and count( $category ) > 0 ) {
		foreach ( $category as $id ) if ( $id == 'all' ) $setall = true;
		if ( $setall ) $category = true;
	}
	$informername = 'dlemovie-' . ( $istext ? 'text' : 'graph' ) . '-' . ( ( $category === true ) ? 'all' : implode( '', $category ) );
	$informername .= '-' . $provider . '-' . $sorting . '-' . $order . '-' . $maxday . '-' . $limit . '-' . $tostr . str_replace( '.tpl', '', $tplfile );
	
	if ( $config['allow_cache'] != 'yes' ) {
		$config['allow_cache'] = 'yes';
		$dlemovie->dleconfig['allow_cache'] = 'yes';
		$revertcache = true;
	} else $revertcache = false;
	
	$informer = dle_cache( $informername );
	if ( $informer !== false ) echo $informer;
	else {
		$dlemovie->category = get_vars( 'dlemovie-category' );
		if ( ! is_array( $dlemovie->category ) ) {
			$dlemovie->category = array( );
			$db->query( "SELECT * FROM " . PREFIX . "_dm_category ORDER BY posi ASC" );
			while ( $row = $db->get_row( ) ) {
				$dlemovie->category[$row['id']] = array( );
				foreach ( $row as $key => $value ) $dlemovie->category[$row['id']][$key] = stripslashes( $value );
			}
			set_vars( 'dlemovie-category', $dlemovie->category );
			$db->free( );
		}
		$informer = '';
		$byprovider = ( $provider != 'all' ) ? " AND provider = '" . $provider . "'" : '';
		$bymaxday = ( $maxday > 0 ) ? " AND date >= " . ( time( ) - $maxday * 86400 ) : '';
		if ( is_array( $category ) and count( $category ) > 0 and $dlemovie->config['categories'] == 'yes' ) {
			$bycategory = '';
			foreach ( $category as $id ) $bycategory .= " OR category = '" . $id . "'";
			$bycategory = " AND ( " . dle_substr( $bycategory, 4, dle_strlen( $bycategory, $config['charset'] ) - 4, $config['charset'] ) . " )";
		} else $bycategory = '';
		if ( $istext == true ) {
			$db->query( "SELECT id, title, category FROM " . PREFIX . "_dm_videos WHERE approved = '1'" . $byprovider . $bymaxday . $bycategory . " ORDER BY " . $sorting . " " . $order . " LIMIT 0, " . $limit );
			if ( $db->num_rows( ) <= 0 ) echo $dlemovie->lang['informer_empty_data'];
			else {
				while ( $row = $db->get_row( ) ) {
					$titleshort = ( dle_strlen( stripslashes( $row['title'] ), $config['charset'] ) > 35 ) ? dle_substr( stripslashes( $row['title'] ), 0, 35, $config['charset'] ) . '...' : stripslashes( $row['title'] );
					$titlebase = totranslit( $titleshort, true, false );
					if ( $dlemovie->config['categories'] == 'yes' and $row['category'] > 0 ) $pagelink = $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $row['id'], 'video/' . $dlemovie->category[$row['category']]['name'] . '/' . $row['id'] . '-' . $titlebase . '.html' );
					else $pagelink = $dlemovie->parseUrl( '?do=video&act=view&video_id=' . $row['id'], 'video/' . $row['id'] . '-' . $titlebase . '.html' );
					$informer .= '<li><a href="' . $pagelink . '" title="' . stripslashes( $row['title'] ) . '">' . $titleshort . '</a></li>';
				}
			}
		} else {
			$db->query( "SELECT " . PREFIX . "_dm_videos.id, title, screen, playtime, category, member, date, views, " . PREFIX . "_dm_videos.rating, comments, allowcomm, " . PREFIX . "_users.name as member_name FROM " . PREFIX . "_dm_videos LEFT JOIN " . PREFIX . "_users ON " . PREFIX . "_dm_videos.member = " . PREFIX . "_users.user_id WHERE approved = '1'" . $byprovider . $bymaxday . $bycategory . " ORDER BY " . $sorting . " " . $order . " LIMIT 0, " . $limit );
			if ( $db->num_rows( ) <= 0 ) echo $dlemovie->lang['informer_empty_data'];
			else {
				$i = 0;
				$tpl->result[$informername] = '';
				$width = round( 100 / $tostr, 0 ) . '%';
				$group = $is_logged ? $member_id['user_group'] : 5;
				$favorite = explode( ',', $member_id['dm_favorite_video'] );
				while ( $row = $db->get_row( ) ) {
					if ( $i == $tostr ) {
						$tpl->result[$informername] .= '</tr><tr><td colspan="' . $tostr . '" style="padding-top:5px;"></td></tr><tr>';
						$i = 1;
					} else $i ++;
					$videocategory = $dlemovie->categoryInfo( $row['category'] );
					$encodetitle = totranslit( ( dle_strlen( $row['title'], $config['charset'] ) > 50 ? dle_substr( $row['title'], 0, 50, $config['charset'] ) : $row['title'] ) );
					
					$tpl->load_template( 'dlemovie/' . $tplfile );
					$tpl->set( '{table-width}', $width );
					$tpl->set( '{video-id}', $row['id'] );
					$tpl->set( '{title}', ( dle_strlen( stripslashes( $row['title'] ), $config['charset'] ) > $dlemovie->config['video_title_max'] ? dle_substr( stripslashes( $row['title'] ), 0, $dlemovie->config['video_title_max'], $config['charset'] ) . '...' : stripslashes( $row['title'] ) ) );
					$tpl->set( '{full-title}', stripslashes( $row['title'] ) );
					$tpl->set( '{preview}', ( empty( $row['screen'] ) ? $config['http_home_url'] . 'uploads/dlemovie/default/video.png' : $config['http_home_url'] . 'uploads/dlemovie/' . stripslashes( $row['screen'] ) ) );
					$tpl->set( '{category-id}', $row['category'] );
					$tpl->set( '{category-name}', $videocategory['title'] );
					$tpl->set( '{category-link}', $videocategory['link'] );
					$tpl->set( '{member-id}', $row['member'] );
					$tpl->set( '{member}', stripslashes( $row['member_name'] ) );
					$tpl->set( '{date}', langdate( $dlemovie->config['date_format'], $row['date'] ) );
					$tpl->set( '{views}', intval( $row['views'] ) );
					$tpl->set( '{rating}', intval( $row['rating'] ) );
					$tpl->set( '{playtime}', $dlemovie->playTime( intval( $row['playtime'] ) ) );
					
					if ( $dlemovie->config['categories'] == 'yes' ) $tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=video&video_id=' . $row['id'], 'video/' . $videocategory['name'] . '/' . $row['id'] . '-' . $encodetitle . '.html' ) );
					else $tpl->set( '{video-link}', $dlemovie->parseUrl( '?do=video&act=video&video_id=' . $row['id'], 'video/' . $row['id'] . '-' . $encodetitle . '.html' ) );
					
					if ( $dlemovie->config['rating_video'] == 'yes' and $user_group[$group]['dm_rating_video'] == 1 ) $tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "\\1" );
					else $tpl->set_block( "'\\[rating\\](.*?)\\[/rating\\]'si", "" );
					
					if ( $row['category'] == 0 ) $tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '' );
					else $tpl->set_block( "'\\[category\\](.*?)\\[/category\\]'si", '\\1' );
					
					if ( $is_logged and $dlemovie->config['favorite_video'] == 'yes' and $user_group[$group]['dm_favorite_video'] ) {
						$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "\\1" );
						if ( in_array( $row['id'], $favorite ) ) {
							$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "\\1" );
							$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
						} else {
							$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
							$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "\\1" );
						}
					} else {
						$tpl->set_block( "'\\[favorite\\](.*?)\\[/favorite\\]'si", "" );
						$tpl->set_block( "'\\[is-favorite\\](.*?)\\[/is-favorite\\]'si", "" );
						$tpl->set_block( "'\\[is-not-favorite\\](.*?)\\[/is-not-favorite\\]'si", "" );
					}					
					if ( $row['allowcomm'] == 1 and $dlemovie->config['comments'] == 'yes' ) {
						$tpl->set( '{comments}', intval( $row['comments'] ) );
						$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '\\1' );
					} else {
						$tpl->set( '{comments}', '' );
						$tpl->set_block( "'\\[comments\\](.*?)\\[/comments\\]'si", '' );
					}
					$tpl->compile( $informername );
				}
				if ( $_REQUEST['__dlemovie_incjs'] != 'yes' ) {
					$informer = $dlemovie->incCssAndJs( true, false ) . '<table width="100%"><tr>' . $tpl->result[$informername] . '</tr></table>' . $dlemovie->incCssAndJs( false, true );
					$_REQUEST['__dlemovie_incjs'] = 'yes';
				} else $informer = '<table width="100%"><tr>' . $tpl->result[$informername] . '</tr></table>';
			}
		}
		echo $informer;
		create_cache( $informername, $informer );
		if ( $revertcache ) {
			$config['allow_cache'] = 'no';
			$dlemovie->dleconfig['allow_cache'] = 'no';
		}
	}
}
?>